import haxe.ds.ObjectMap;

public var iconList:Array<Array<HealthIcon>> = [];
public var iconOffsets:ObjectMap<FlxPoint> = new ObjectMap();

public function addIconToList(icon:HealthIcon, onLeft:Bool, laneIndex:Int) {
	iconList.push([icon, onLeft, laneIndex]);
	if (!iconOffsets.exists(icon))
		iconOffsets.set(icon, FlxPoint.get());
}
public function removeIconFromList(icon:HealthIcon) {
	for (setup in iconList) {
		if (icon == setup[0]) {
			iconList.remove(setup);
			break;
		}
	}
}

function postCreate() {
	addIconToList(iconP2, true, 0);
	addIconToList(iconP1, false, 1);
}

function postUpdate(elapsed) {
	if (doSmoothIcons) return;

	for (setup in iconList) {
		var icon:HealthIcon = setup[0];
		var onLeft:Bool = setup[1];

		var iconOffset:Int = 26;
		var center:Float = healthBar.x + healthBar.width * FlxMath.remapToRange(healthBar.percent, 0, 100, 1, 0);

		if (onLeft) {
			icon.x = center - (icon.width - iconOffset) - iconOffsets.get(icon).x;
			icon.health = 1 - (healthBar.percent / 100) + iconOffsets.get(icon).x;
		} else {
			icon.x = center - iconOffset;
			icon.health = healthBar.percent / 100;
		}
		icon.y = healthBar.y - (icon.height / 2) + iconOffsets.get(icon).y;
	}
}

function destroy() {
	for (point in iconOffsets) {
		point.put();
	}
}